/************************************************************************
* COPYRIGHT:   Copyright    1998 Symbol Technologies, Inc. 
*
* FILE:        ptPrint.h
*
* SYSTEM:      Symbol Print API.
*
* HEADER:      Print API Library Header
*
* DESCRIPTION: Provides function declarations and other types for
*			   use by a print application.
*
* HISTORY:   02/19/99    Mitchs  Created
*	      	12/31/00	Inv.	Removed PalmCompatibility.h for PalmOS 3.5 conversion
*
*              
*************************************************************************/
#pragma once

#ifdef __cplusplus
   extern "C" {
#endif
#include <SerialMgr.h>


/*
 *	Return Code Status
 */
typedef enum tagPTStatus
{
	PTStatusOK			=	0,
	PTStatusFail,
	PTStatusRomIncompatible,
	PTStatusBadParmeter,
	PTStatusTransportNotAvail,
	PTStatusErrLine,
	PTStatusNotOpen,
	PTStatusAlreadyOpen,
	PTStatusNoMemory,
	PTStatusAlreadyConnect,
	PTStatusPrinterNotFound,
	PTStatusTimeOut,
	PTStatusPending,
	PTStatusNoPeerAddr,
	PTStatusIrBindFailed,
	PTStatusIrNoDeviceFound,
	PTStatusIrDicoverFail,
	PTStatusIrConnectFailed,
	PTStatusIrConnectLapFailed,
	PTStatusIrQueryFailed,
	PTStatusPrintCapFailed
		
} PTStatus;

/*
 *	Supported Transports
 */
typedef enum tagPTTransports
{
	PTUnknown			= 0,
	PTSerial,
	PTIr
		
} PTTransport;

/*
 *	Communication Settings
 */
typedef struct tagPTConnectSettings {

	UInt32			baudRate;			// baud rate
	UInt32			timeOut;			// time out in System Ticks
	UInt32			flags;				// 
	UInt16			recvBufSize;		// receive buffer size
	
} PTConnectSettings;

typedef PTConnectSettings * PTConnectSettingsPtr;

/*
 *	Serial Defaults
 */
#define		PTDefaultSerBaudRate	9600
#define		PTDefaultSerFlags		serDefaultSettings
#define		PTDefaultSerTimeout		(5 * sysTicksPerSecond)

/*
 *	Ir Defaults
 */
#define		PTDefaultIrBaudRate		irOpenOptSpeed57600
#define 	PTDefaultIrTimeout		(4 * sysTicksPerSecond)
#define		PTDefaultSerRecvBuf		512

/*******************************************************************
 *	Low-Level API Functions                                        *
 *	Functions for opening and closing                              *
 *******************************************************************/

PTStatus ptOpenPrinter( Char *  printerModel, PTTransport transport,
						PTConnectSettingsPtr customSettings );

PTStatus ptClosePrinter( );

PTStatus ptConnectPrinter( Char *  printerName );

PTStatus ptDisconnectPrinter();

PTStatus ptInitPrinter( MemPtr initPtr, UInt32 length );

PTStatus ptResetPrinter( MemPtr resetPtr, UInt32 length );

PTStatus ptQueryPrinter( MemPtr queryPtr, UInt32 length, 
						 MemPtr queryResPtr, UInt32* rtnLength );
 
PTStatus ptWritePrinter( MemPtr buffer, UInt32 length );

PTStatus ptQueryPrintCap( MemPtr query, MemPtr queryResPtr, 
						  UInt32* rtnLength );
						  
PTStatus ptPrintApiVersion( Char *  ptr, Int16 len );

/*******************************************************************
 *	High-Level API Functions                                       *
 *******************************************************************/
 
PTStatus ptStartPrintBuffer( UInt32 size );

PTStatus ptSetFont( Char *  fontBuffPtr );

PTStatus ptTextToBuffer( UInt16 xStart, UInt16 yStart, Char *  pText );

PTStatus ptLineToBuffer( UInt16 xStart, UInt16 yStart, 
						 UInt16 xEnd,   UInt16 yEnd, UInt16 lineThickness );

PTStatus ptRectToBuffer( UInt16 xTopLeft,     UInt16 yTopLeft,
						 UInt16 xBottomRight, UInt16 yBottomRight, 
						 UInt16 lineThickness );

PTStatus ptResetPrintBuffer();

PTStatus ptPrintPrintBuffer( Char *  printerName );

#ifdef __cplusplus
    }
#endif
/*******************************************************************
 *              end of file                                        *
 *******************************************************************/
